import pandas as pd
import numpy as np
import math
import os
import scipy.optimize as optimize
import warnings
warnings.filterwarnings('ignore')

# The parameter used to calculate the discount rate
rho = [4,5,6,7,8,9,10]
psi = [0.25, 0.2, 0.16666667, 0.14285714, 0.125, 0.11111111, 0.1]
smav = [0.13, 0.1029563, 0.1024695]
smay = [0.24166, 0.27166, 0.32496]
ret_fac = [0.80, 0.60, 0.40]
rf = [0.02, 0.01, 0.00]
mu = [0.04, 0.03, 0.02]
aa = [-1.9317, 0.4914, 0.530339]
b1 = [0.3194, 0.1684, 0.16818]
b2 = [-0.00577, -0.00353, -0.00323371]
b3 = [0.000033, 0.000023, 0.000019704]

age = list(range(22,101,1))

surv_prob = [0.99925, 0.99916, 0.99908, 0.99902, 0.99898, 0.99894, 0.9989, 0.99886, 0.99881, 0.99875, 0.99869, 0.99863, 0.99856, 0.9985, 0.99844, 0.99836, 0.99829, 0.99822, 0.99815, 0.99809, 0.99801, 0.99791, 0.99779, 0.99766, 0.9975, 0.99732, 0.99712, 0.99691, 0.99667, 0.99639, 0.9961, 0.99576, 0.99536, 0.99489, 0.99439, 0.99388, 0.99337, 0.99283, 0.99225, 0.99161, 0.99091, 0.99019, 0.98948, 0.9888, 0.98811, 0.98738, 0.9865, 0.98553, 0.98443, 0.9832, 0.98186, 0.98032, 0.97881, 0.97647, 0.97442, 0.97171, 0.969, 0.96551, 0.96193, 0.95785, 0.95341, 0.94841, 0.94226, 0.93546, 0.92836, 0.91947, 0.91026, 0.89952, 0.88775, 0.87491, 0.86096, 0.8459, 0.82974, 0.81251, 0.79425, 0.77505, 0.75501, 0.73425]


# Function used to calculate the discount rate
def find_discount_rate(index, data):
    rho_use = rho[int(index[0])]
    psi_use = psi[int(index[0])]
    smav_use = smav[int(index[1])]
    smay_use = smay[int(index[2])]
    ret_fac_use = ret_fac[int(index[3])]
    rf_use = rf[int(index[4])]
    mu_use = mu[int(index[5])]
    aa_use = aa[int(index[6])]
    b1_use = b1[int(index[6])]
    b2_use = b2[int(index[6])]
    b3_use = b3[int(index[6])]
    
    data = data
    data['wealth'] = data['cash'] - data['consumption']        
    
    sigma = 0.185
    alpha = (mu_use+1/2*sigma**2)/(rho_use*sigma**2)
    
    labor = []
    for i in range(45):
        labor.append(math.exp(aa_use+b1_use*age[i]+b2_use*age[i]**2+b3_use*age[i]**3))
    for i in range(45,79,1):
        labor.append(math.exp(aa_use+b1_use*66+b2_use*66**2+b3_use*66**3))
    
    rate = []
    
    last_discount = 0.02

    for j in range(77, -1, -1):
        print(j+22)
        data_a = data[data['age'] == j+22]
        data_a = data_a[data_a['wealth']>0.25]
        n = len(data_a)
        
        if j>= 44:
            def MSE_post_ret(r):
                
                discount = []
                m = 79-j-1
                for k in range(m):  
                    if k==0:
                        discount.append(1.0/(1+r))     
                    else:
                        d = 1+r
                        for p in range(k):
                            d = d*(1+rate[m-p-2])
                        discount.append(1.0/d)       
                H = sum(discount)
                alpha_fit = []
                for k in range(n):
                    alpha_fit.append(min(1,alpha*(1+H/data_a['wealth'].iloc[k])))

                dif = [(x-y)**2 for x, y in zip(alpha_fit,list(data_a['alpha_r']))]
                mse = sum(dif)/n
                return(mse)

            initial_guess = last_discount
            result = optimize.minimize(MSE_post_ret, initial_guess)
            last_discount = result.x[0]
            rate.append(result.x[0])
            # print(result.x[0])
        
        else: 
            def MSE_pre_ret(r):
                
                sub_labor = labor[(j+1):]   # labor income in the future 
                m = len(sub_labor)
                discount = []
                
                for k in range(m):
                    if j+k<44:          # non-retirement period
                        if k==0:        # current age, discount rate r is unknown
                            discount.append(sub_labor[k]/(1+r)*math.exp(0.5*((k+1)*smav_use**2+smay_use**2))/labor[j])
                        else:           
                            d = 1+r
                            for p in range(k):
                                d = d*(1+rate[m-p-2])  # cumulative product of future discount rate
                            discount.append(sub_labor[k]/d*math.exp(0.5*((k+1)*smav_use**2+smay_use**2))/labor[j])
                    else: # retirement period
                        d = 1+r
                        for p in range(k):
                            d = d*(1+rate[m-p-2])
                        discount.append(sub_labor[k]*ret_fac_use/d*math.exp(0.5*(44-j)*smav_use**2)/labor[j])
                H = sum(discount)
                alpha_fit = []
                for k in range(n):
                    alpha_fit.append(min(1,alpha*(1+H/data_a['wealth'].iloc[k])))

                dif = [(x-y)**2 for x, y in zip(alpha_fit,list(data_a['alpha_r']))]
                mse = sum(dif)/n
                return(mse)

            initial_guess = last_discount
            result = optimize.minimize(MSE_pre_ret, initial_guess)
            last_discount = result.x[0]
            rate.append(result.x[0])
            
    rate.reverse()
        
    return rate


# Calculate the discount rate

index_str = os.path.basename(os.getcwd())

#os.remove('discount_rate.csv')

data2d = pd.read_csv('age_profile.csv')

rate_cal = find_discount_rate(index_str, data2d)

age = list(range(22, 100))

df_rate = pd.DataFrame({'age': age, 'discount_rate': rate_cal})

df_rate.to_csv('discount_rate.csv', index = False)

