import os
import pandas as pd
import numpy as np

def import_value_function(allocation_rule):
    
    arr_1 = np.loadtxt('V_' + allocation_rule + '.txt')
    arr_1 = np.reshape(arr_1, (-1, 80))
    df_1 = pd.DataFrame(arr_1)
    df_1.columns = [str(i) for i in range(20, 100)]
    df_1.rename(columns = {'20': 'cash'}, inplace = True)
    
    long_df_1 = df_1.melt(id_vars = 'cash', value_vars = [str(i) for i in range(21, 100)], var_name = 'age', value_name = 'value_function_' + allocation_rule)
    long_df_1['age'] = long_df_1['age'].astype(int)
    long_df_1.sort_values(by = ['age', 'cash'], inplace = True)
    
    # delete some data and export to csv
    long_df_1['age'] = long_df_1['age']+1
    long_df_1 = long_df_1[long_df_1.age != 100]
    
    return long_df_1


df_zero = import_value_function("zero")
df_one = import_value_function("one")
df_sixty = import_value_function("sixty")
df_age = import_value_function("age")
df_appro = import_value_function("appro")

long_df = pd.merge(df_zero, df_one, on = ['cash', 'age'])
long_df = pd.merge(long_df, df_sixty, on = ['cash', 'age'])
long_df = pd.merge(long_df, df_age, on = ['cash', 'age'])
long_df = pd.merge(long_df, df_appro, on = ['cash', 'age'])

data2d = pd.read_csv('age_profile.csv')
data2d = data2d[['cash', 'age', 'value_function']]
long_df = pd.merge(long_df, data2d, on = ['cash', 'age'])
long_df.sort_values(by = ['age', 'cash'], inplace = True)

long_df.to_csv('value_function.csv', index = False)

long_df_select = long_df[(long_df['age'] == 22) & (long_df['cash'] == 1.017918)]
long_df_select.to_csv('value_function_1point.csv', index = False)

