import os
import pandas as pd
import numpy as np


# import A.txt and reshape the data
arr_a = np.loadtxt('A.txt')
arr_a = np.reshape(arr_a, (-1, 80))
df_a = pd.DataFrame(arr_a)
df_a.columns = [str(i) for i in range(20, 100)]
df_a.rename(columns = {'20': 'cash'}, inplace = True)

long_df_a = df_a.melt(id_vars = 'cash', value_vars = [str(i) for i in range(21, 100)], var_name = 'age', value_name = 'alpha_r')
long_df_a['age'] = long_df_a['age'].astype(int)
long_df_a.sort_values(by = ['age', 'cash'], inplace = True)

# import C.txt and reshape the data
arr_c = np.loadtxt('C.txt')
arr_c = np.reshape(arr_c, (-1, 80))
df_c = pd.DataFrame(arr_c)
df_c.columns = [str(i) for i in range(20, 100)]
df_c.rename(columns = {'20': 'cash'}, inplace = True)

long_df_c = df_c.melt(id_vars = 'cash', value_vars = [str(i) for i in range(21, 100)], var_name = 'age', value_name = 'consumption')
long_df_c['age'] = long_df_c['age'].astype(int)
long_df_c.sort_values(by = ['age', 'cash'], inplace = True)

# merge with alpha_r data
long_df_a_c = pd.merge(long_df_a, long_df_c, on = ['cash', 'age'])
long_df_a_c.sort_values(by = ['age', 'cash'], inplace = True)


# import V.txt and reshape the data
arr_v = np.loadtxt('V.txt')
arr_v = np.reshape(arr_v, (-1, 80))
df_v = pd.DataFrame(arr_v)
df_v.columns = [str(i) for i in range(20, 100)]
df_v.rename(columns = {'20': 'cash'}, inplace = True)

long_df_v = df_v.melt(id_vars = 'cash', value_vars = [str(i) for i in range(21, 100)], var_name = 'age', value_name = 'value_function')
long_df_v['age'] = long_df_v['age'].astype(int)
long_df_v.sort_values(by = ['age', 'cash'], inplace = True)

# merge with alpha_r&consumption data
long_df = pd.merge(long_df_a_c, long_df_v, on = ['cash', 'age'])
long_df.sort_values(by = ['age', 'cash'], inplace = True)

# delete some data and export to csv
long_df['age'] = long_df['age']+1
long_df['wealth'] = long_df.cash - long_df.consumption
long_df = long_df[long_df.age != 100]
long_df.to_csv('age_profile.csv')

#os.remove('A.txt')
#os.remove('C.txt')
#os.remove('V.txt')