import numpy as np
import pandas as pd

# Write the value function from CGM into V_max.txt
age_df = pd.read_csv('age_profile.csv')
k_value = age_df.pivot(index=['cash'], columns='age', values='value_function')
k_value.reset_index(inplace=True)
l_value = k_value.to_numpy()
l_value = l_value[:,:]

with open("V_max.txt", "w") as file:
    # Iterate over each row in the array
    for row in l_value:
        # Write the first two elements of the row on a new line
        file.write(f"{row[0]}\n")
        
        # Write the remaining 79 elements of the row on the next line
        file.write(" ".join(map(str, row[1:])) + "\n")

# Write the optimal allocation from CLL into A_cll.txt
fit_df = pd.read_csv('reg_fit_alpha.csv') 
k_cll = fit_df.pivot(index=['cash'], columns='age', values='alpha_fit_reg')
k_cll.reset_index(inplace=True)
l_cll = k_cll.to_numpy()
l_cll = l_cll[:,:]

with open("A_fit.txt", "w") as file:
    # Iterate over each row in the array
    for row in l_cll:
        # Write the first two elements of the row on a new line
        file.write(f"{row[0]}\n")
        
        # Write the remaining 79 elements of the row on the next line
        file.write(" ".join(map(str, row[1:])) + "\n")